#include <bits/stdc++.h>
using namespace std;

vector<int> nextGreaterRight(const vector<int>& heights) {
    int n = heights.size();
    vector<int> right(n, -1);
    stack<int> st;
    
    for (int i = 0; i < n; i++) {
        while (!st.empty() && heights[st.top()] <= heights[i]) {
            right[st.top()] = i;
            st.pop();
        }
        st.push(i);
    }
    return right;
}

vector<int> nextGreaterLeft(const vector<int>& heights) {
    int n = heights.size();
    vector<int> left(n, -1);
    stack<int> st;
    
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty() && heights[st.top()] <= heights[i]) {
            left[st.top()] = i;
            st.pop();
        }
        st.push(i);
    }
    return left;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    cin >> n;
    
    vector<long long> positions(n);
    for (int i = 0; i < n; i++) {
        cin >> positions[i];
    }
    
    vector<int> heights(n);
    for (int i = 0; i < n; i++) {
        cin >> heights[i];
    }
    
    
    vector<long long> distances(n - 1);
    for (int i = 0; i < n - 1; i++) {
        distances[i] = positions[i + 1] - positions[i];
    }
    
    
    vector<long long> prefix(n);
    prefix[0] = 0;
    for (int i = 1; i < n; i++) {
        prefix[i] = prefix[i - 1] + distances[i - 1];
    }
    
    
    vector<int> right = nextGreaterRight(heights);
    vector<int> left = nextGreaterLeft(heights);
    
    for (int i = 0; i < n; i++) {
        long long ans_right = LLONG_MAX / 2;
        long long ans_left = LLONG_MAX / 2;
        
        
        if (right[i] != -1) {
            long long total_dist = prefix[right[i]] - prefix[i];
            long long height_diff = heights[right[i]] - heights[i];
            ans_right = total_dist - height_diff;
            
            
            if (ans_right == 0 && i < n - 1) {
                ans_right = distances[i];
            }
        }
        
        if (left[i] != -1) {
            long long total_dist = prefix[i] - prefix[left[i]];
            long long height_diff = heights[left[i]] - heights[i];
            ans_left = total_dist - height_diff;
            
            
            if (ans_left == 0 && i > 0) {
                ans_left = distances[i - 1];
            }
        }
        
        if (ans_right == LLONG_MAX / 2 && ans_left == LLONG_MAX / 2) {
            cout << "-1\n";
        } else {
            cout << min(ans_right, ans_left) << '\n';
        }
    }
}